# Gender Inequality

##
## Fertility (World Bank Data)
##
wdilist <- c("SP.DYN.TFRT.IN") # Fertility rate, total (births per woman)

# Extract latest version of desired variables from WDI.
wdi <- WDI(country="all", indicator = wdilist, extra = FALSE,
           start = 1989, end = 2009)

wdi$actorid <- countrycode(wdi$iso2c, "iso2c", "cown", warn = T)
wdi$actorid[wdi$country=="Kosovo"] <- 347 # Kosovo 
wdi$actorid[wdi$country=="Serbia"] <- 345 # Serbia (Yugoslavia)
wdi$actorid[wdi$country=="South Sudan"] <- 626 # South Sudan (to be sure that it does not match Sudan)
wdi$actorid[wdi$country=="Yemen, Rep."] <- 678 # used in SVAC for Yemen (In CoW: Yemen Arab Republic!)
wdi$actorid[wdi$country=="South Africa"] <- 560 # South Africa
wdi$actorid[wdi$country=="Zimbabwe"] <- 552 # Zimbabwe

wdi <- rename(wdi, c("SP.DYN.TFRT.IN"="wdi.fertility"))

wdi <- subset(wdi, is.na(actorid)==FALSE, 
              select=c(actorid, year, wdi.fertility))

Master <- join(Master, wdi, type="left", by=c("actorid", "year"), match="all")


## Obsolete - manual fertility data retrivial and transformation

# wb.fertility <- read.csv(file = "Daten/World Bank Fertility//fertility.csv", header = T, sep = ",")
# wb.fertility$actorid <- countrycode(wb.fertility$Country.Code, "wb", "cown",warn = T) # add COW-IDs
# wb.fertility <- subset(wb.fertility, subset = !is.na(wb.fertility$actorid)) # delete all rows w/o COW-IDs
# wb.fertility <- subset(wb.fertility, select = c("actorid", "X1989", "X1990", "X1991", "X1992", 
#                                                 "X1993", "X1994", "X1995", "X1996", "X1997", "X1998", 
#                                                 "X1999", "X2000", "X2001", "X2002", "X2003", "X2004", 
#                                                 "X2005", "X2006", "X2007", "X2008" ,"X2009"))
# 
# wb.fertility <- rename(wb.fertility, c("actorid"="actorid","X1989"="1989",
#                                       "X1990"="1990","X1991"="1991","X1992"="1992","X1993"="1993","X1994"="1994",
#                                       "X1995"="1995","X1996"="1996","X1997"="1997","X1998"="1998","X1999"="1999",
#                                       "X2000"="2000","X2001"="2001","X2002"="2002","X2003"="2003","X2004"="2004",
#                                       "X2005"="2005","X2006"="2006","X2007"="2007","X2008"="2008","X2009"="2009"))
# 
# wb.fertility <- melt(wb.fertility, id.vars=c("actorid")) # from long to wide format
# wb.fertility <- rename(wb.fertility, c("actorid"="actorid", "variable"="year", "value"="wb_fertility"))
# wb.fertility$year <- as.numeric(as.character(wb.fertility$year))
# #wb.fertility <- wb.fertility[order(wb.fertility$actorid, wb.fertility$year),]


##
## CIRI Data
##
##
## other forms of political violence / CIRI data
##
CIRI <- read.csv(file = "Daten/CIRI Human Rights Data//CIRI Data 1981_2011 2014.04.14.csv", 
                 header = T, sep = ",")
CIRI <- subset(CIRI, select = c(YEAR, POLITY, WECON, WOPOL, WOSOC))
CIRI <- rename(CIRI, c("YEAR" = "year", "POLITY" = "actorid", "WECON" = "ciri_wecon", 
                       "WOPOL" = "ciri_wopol", "WOSOC" = "ciri_wosoc"))


# recode all others [0;2]
# 0=women’s rights were not guaranteed by law during a given year.
# 1=women’s rights were guaranteed in law, but severely prohibited in practice. 
# 2=women’s rights were guaranteed in law, but were still moderately prohibited in practice. 
# 3=women’s rights were guaranteed in both law and practice.
CIRI$ciri_wecon <- recode(CIRI$ciri_wecon, "0=3;1=2;2=1;3=0")
CIRI$ciri_wopol <- recode(CIRI$ciri_wopol, "0=3;1=2;2=1;3=0")
CIRI$ciri_wosoc <- recode(CIRI$ciri_wosoc, "0=3;1=2;2=1;3=0")

# from dplyr help: << type="left": all rows in x, adding matching columns from y >>
Master <- join(Master, CIRI, type="left", by=c("actorid", "year"), match="all")
# define missing values
Master$ciri_wecon[Master$ciri_wecon=="-999" | Master$ciri_wecon=="-77" | Master$ciri_wecon=="-66"] <- NA 
Master$ciri_wopol[Master$ciri_wopol=="-999" | Master$ciri_wopol=="-77" | Master$ciri_wopol=="-66"] <- NA 
Master$ciri_wosoc[Master$ciri_wosoc=="-999" | Master$ciri_wosoc=="-77" | Master$ciri_wosoc=="-66"] <- NA 

rm(wdi, CIRI)
